IF not EXISTS ( SELECT * FROM SYS.OBJECTS
		WHERE NAME ='EST_PROD_CPL_IMP_PLU')
begin
	CREATE TABLE [dbo].[EST_PROD_CPL_IMP_PLU](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_PROD] [int] NOT NULL,
		[CD_PLU] [varchar](50) NOT NULL,
		[QT_EST] MONEY NOT NULL,
		[QT_PEND_ENT] MONEY NOT NULL,
		[QT_PEND_SAI] MONEY NOT NULL,
		[QT_EMB] MONEY NOT NULL,
		[VLR_VD] MONEY NOT NULL,
		[DT_HR_INF] datetime not null,
	 CONSTRAINT [PK_EST_PROD_CPL_IMP_PLU] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_PROD] ASC,
		[CD_PLU] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, 
	ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_PROD_CPL_IMP_PLU] ADD  CONSTRAINT [DF_EST_PROD_CPL_IMP_PLU_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].[EST_PROD_CPL_IMP_PLU] ADD  CONSTRAINT [DF_EST_PROD_CPL_IMP_PLU_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

	ALTER TABLE [dbo].[EST_PROD_CPL_IMP_PLU] ADD  CONSTRAINT [DF_EST_PROD_CPL_IMP_PLU_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

	ALTER TABLE [dbo].[EST_PROD_CPL_IMP_PLU] ADD  CONSTRAINT [DF_EST_PROD_CPL_IMP_PLU_QT_EST]  DEFAULT ((0)) FOR [QT_EST]

	ALTER TABLE [dbo].[EST_PROD_CPL_IMP_PLU] ADD  CONSTRAINT [DF_EST_PROD_CPL_IMP_PLU_QT_PEND_ENT]  DEFAULT ((0)) FOR [QT_PEND_ENT]

	ALTER TABLE [dbo].[EST_PROD_CPL_IMP_PLU] ADD  CONSTRAINT [DF_EST_PROD_CPL_IMP_PLU_QT_PEND_SAI]  DEFAULT ((0)) FOR [QT_PEND_SAI]

	ALTER TABLE [dbo].[EST_PROD_CPL_IMP_PLU] ADD  CONSTRAINT [DF_EST_PROD_CPL_IMP_PLU_QT_EMB]  DEFAULT ((0)) FOR [QT_EMB]

	ALTER TABLE [dbo].[EST_PROD_CPL_IMP_PLU] ADD  CONSTRAINT [DF_EST_PROD_CPL_IMP_PLU_VLR_VD]  DEFAULT ((0)) FOR [VLR_VD]

	ALTER TABLE [dbo].[EST_PROD_CPL_IMP_PLU] ADD  CONSTRAINT [DF_EST_PROD_CPL_IMP_PLU_CD_PLU]  DEFAULT ('') FOR [CD_PLU]

	ALTER TABLE [dbo].[EST_PROD_CPL_IMP_PLU]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_CPL_IMP_PLU_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
	REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])
	ON UPDATE CASCADE
	ON DELETE CASCADE

	ALTER TABLE [dbo].[EST_PROD_CPL_IMP_PLU] CHECK CONSTRAINT [FK_EST_PROD_CPL_IMP_PLU_EST_PROD]
end


